#pragma once

#include <vector>
#include "resource.h"
#include "PCAN-ISO-TP.h"
#include "MappingStatus.h"
#include "afxwin.h"
#include "afxcmn.h"
#include "PCanIsoTpExampleDlgAddNewMappings.h"

// CPCanIsoTpExampleDlgMappings dialog

class CPCanIsoTpExampleDlgMappings : public CDialogEx
{
	friend class CPcanIsoTpExampleDlg;
	DECLARE_DYNAMIC(CPCanIsoTpExampleDlgMappings)
public:
	CPCanIsoTpExampleDlgMappings(TPCANTPHandle *p_pctpHandle, CWnd* pParent = NULL);   // standard constructor
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_PCANISOTPEXAMPLE_TAB_MAPPINGS };
#endif

public_member:
	TPCANTPHandle *m_pctpHandle; // Handle selected on combobox Channel
	std::vector<MappingStatus*> m_mappings; // List of configured PCAN-ISO-TP mappings.

public_method:
	void AddData(MappingStatus* p_mapping);
	void MappingsAdd(MappingStatus* mapping);
	void MappingsInit();
	void ResetMappingList();
	void MappingsChanged();

protected_method:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void PostNcDestroy();
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnBnClickedButtonExample();
	afx_msg void OnBnClickedButtonRemove();
	afx_msg void OnBnClickedButtonAdd();
	afx_msg void OnBnClickedButtonSaveMappings();
	afx_msg void OnBnClickedButtonLoadMappings();
	afx_msg void OnLvnItemchangedListMappings(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnInsertitemListMappings(NMHDR *pNMHDR, LRESULT *pResult);

protected_properties:
	// Dialog Data
	CButton buttonMappingAdd;
	CButton buttonMappingSample;
	CButton buttonLoadMappings;
	CButton buttonMappingDel;
	CButton buttonSaveMappings;
	CListCtrl listViewMappings;
};
